TYPE InventoryData
    Item AS STRING * 20
    RoomFound AS _UNSIGNED _BYTE
    InInventory AS _UNSIGNED _BYTE
    InventoryMessage AS STRING * 255
END TYPE

DIM SHARED Map(159) AS _UNSIGNED _BYTE
DIM SHARED MapWidth AS _UNSIGNED _BYTE
DIM SHARED MapHeight AS _UNSIGNED _BYTE

REDIM SHARED Inventory(-1) AS InventoryData

DIM SHARED MaxGameMinutes AS _UNSIGNED INTEGER
DIM SHARED MaxGameSeconds AS _UNSIGNED INTEGER
DIM SHARED DoomTime AS _FLOAT
DIM SHARED CurrentRoom AS _UNSIGNED INTEGER
DIM SHARED Directions AS _UNSIGNED INTEGER

REDIM SHARED WordList$(-1)
DIM SHARED Key$
DIM SHARED LanguageWarning

REDIM SHARED Tokens$(-1)

' Read the game map
FOR Room = 0 TO 159
    READ Map(Room)
NEXT

MapWidth = 10
MapHeight = 16

' Read the Inventory
DO
    READ Item$, RoomFound, InInventory, InventoryMessage$

    IF Item$ <> "END_OF_ITEMS" THEN
        REDIM _PRESERVE Inventory(UBOUND(Inventory) + 1) AS InventoryData
        Inventory(UBOUND(Inventory)).Item = Item$
        Inventory(UBOUND(Inventory)).RoomFound = RoomFound
        Inventory(UBOUND(Inventory)).InInventory = InInventory
        Inventory(UBOUND(Inventory)).InventoryMessage = InventoryMessage$
    END IF

LOOP WHILE Item$ <> "END_OF_ITEMS"

'  READ LISTS OF PHRASE THAT THE USER SHOULDN'T TYPE
READ Key$
READ NumberOfPhrases

REDIM SHARED WordList$(NumberOfPhrases)

'  ITERATE THROUGH THE PHRASE LIST AND DECODE
FOR i = 0 TO NumberOfPhrases - 1
    READ WordList$(i)

    '  DECODE PHRASE
    FOR c~& = 1 TO LEN(WordList$(i))
        OldChar = ASC(MID$(WordList$(i), c~&, 1))
        FOR KeyChar~%% = 32 TO 126
            IF ASC(MID$(Key$, KeyChar~%%, 1)) = OldChar THEN NewChar~%% = KeyChar~%%: EXIT FOR
        NEXT
        MID$(WordList$(i), c~&, 1) = CHR$(NewChar~%%)
    NEXT
NEXT

' Set the graphics mode
SCREEN 12

'  CHANGE COLOR #3 (&HFF00A8A8) TO A DIFFERENT COLOR
OUT &H3C8, 3 '  TELL THE HDAC WE WANT TO CHANGE A COLOR
OUT &H3C9, 0 '  RED
OUT &H3C9, 133 '  GREEN
OUT &H3C9, 255 '  BLUE


' **************************************************************************************
' Show introduction story
DrawBox 1, 1, 80, 7, 11, 1, 176

_PRINTMODE _KEEPBACKGROUND
COLOR 14, 0
LOCATE 3, 4: PRINT "The Field"
LOCATE 4, 4: PRINT "Written By: D.B. Taylor"
LOCATE 5, 4: PRINT "Copyrighted 2015, By D.B. Taylor. All Rights Reserved."

COLOR 10, 0
LOCATE 10, 6: PRINT "  Introduction:"

COLOR 2, 0
LOCATE 12, 1
PRINT "       The summer season fades away into fall and you can feel the cold"
PRINT "       grasp of the air tightly grip you. You awake and found yourself"
PRINT "       standing in a field. How you got here is unknown. Maybe, you'll"
PRINT "       wander around and find your way home? "
PRINT
PRINT "       The spirits of the night like to fool the living."

DrawBox 1, 28, 80, 30, 3, 1, 176

_PRINTMODE _KEEPBACKGROUND
COLOR 14, 0
LOCATE 29, 21: PRINT "PRESS ANY KEY TO START YOUR EXPLORATION";
_PRINTMODE _FILLBACKGROUND

DO: LOOP UNTIL INKEY$ <> ""

' **************************************************************************************

MaxGameMinutes = 45
MaxGameSeconds = 0
CurrentRoom = 152

DoomTime = TIMER(0.001) + (MaxGameMinutes * 60 + MaxGameSeconds) 'change this to to desied time for the game to run

' **************************************************************************************
' MAIN LOOP
' **************************************************************************************
DO
    _LIMIT 30

    CLS

    COLOR 8, 0

    _PRINTMODE _KEEPBACKGROUND

    PRINT
    PRINT

    PRINT "                                 ";: COLOR 7, 0: PRINT "The Field";: COLOR 8, 0: PRINT "     "
    PRINT "                                                  "

    COLOR 1, 0

    PRINT "                               Written   By"
    PRINT "                                  D.B.   Taylor"
    PRINT "                             Copyright   (c) 2015"
    PRINT

    _PRINTMODE _FILLBACKGROUND

    ' GET AVAILABLE DIRECTIONS FROM MAP
    Directions = (Map(CurrentRoom) AND &HF0) / 16

    ' SHOW NORTH
    PRINT SPACE$(39);
    COLOR 1, 0
    IF (Directions AND 1) AND ((Map(CurrentRoom) AND 1) = 0) THEN COLOR 10, 0
    IF (Directions AND 1) AND ((Map(CurrentRoom) AND 1) = 1) THEN COLOR 12, 0
    PRINT "N"

    ' SHOW WEST
    COLOR 5, 0
    PRINT "*----------------------------------* ";
    COLOR 1, 0
    IF (Directions AND 4) AND ((Map(CurrentRoom) AND 4) = 0) THEN COLOR 10, 0
    IF (Directions AND 4) AND ((Map(CurrentRoom) AND 4) = 4) THEN COLOR 12, 0
    PRINT "W";

    ' SHOW EAST
    COLOR 3, 0: PRINT " + ";: COLOR 2, 0
    COLOR 1, 0
    IF (Directions AND 2) AND ((Map(CurrentRoom) AND 2) = 0) THEN COLOR 10, 0
    IF (Directions AND 2) AND ((Map(CurrentRoom) AND 2) = 2) THEN COLOR 12, 0
    PRINT "E";

    ' SHOW SOUTH
    COLOR 5, 0
    PRINT " *-----------------------------------*"
    PRINT SPACE$(39);
    COLOR 1, 0
    IF (Directions AND 8) AND ((Map(CurrentRoom) AND 8) = 0) THEN COLOR 10, 0
    IF (Directions AND 8) AND ((Map(CurrentRoom) AND 8) = 8) THEN COLOR 12, 0
    PRINT "S"

    ' DRAW FOOTER BAR
    LOCATE 30, 1: COLOR 0, 1: PRINT STRING$(80, " ");

    ' SHOW FOOTER HELP INFORMATION
    _PRINTMODE _KEEPBACKGROUND
    LOCATE 30, 16: COLOR 10, 0: PRINT "IF YOU ARE STUCK, JUST TYPE 'HELP', 'H', OR '?'.";: COLOR 2, 0
    _PRINTMODE _FILLBACKGROUND

    ' POSITION START LOCATION OF ROOM INFORMATION
    LOCATE 22, 1

    ' SHOW ROOM INFORMATION
    DisplayRoomInformation (CurrentRoom)

    ' GET USER INPUT AND PARSE
    GetInputAndParse

    _DISPLAY


LOOP

SYSTEM



' **************************************************************************************
' SHOW HELP
' **************************************************************************************
SUB ShowHelp ()

CLS

DrawBox 3, 2, 78, 29, 3, 1, 176
DrawBox 5, 3, 76, 8, 11, 3, 178 '10, 9, 178

_PRINTMODE _KEEPBACKGROUND

COLOR 14, 0
LOCATE 5, 22: PRINT "HELP SYSTEM: LIST OF IN GAME COMMANDS"
LOCATE 6, 7: PRINT "---=== THESE DO NOT INCLUDE ANY OBJECTS, ITEMS, OR CHARACTERS ==---"
LOCATE 26, 9: PRINT "MY GRANDFATHER'S WATCH IS STILL TICKING AND TIME IS RUNNING OUT!"
LOCATE 27, 10: PRINT "I BETTER GET BACK TO MY JOURNEY BEFORE SOMETHING BAD HAPPENS.";
COLOR 9, 0: LOCATE 28, 30: PRINT "HINT: PRESS ANY KEY";

COLOR 11, 0: LOCATE 12, 9: PRINT "END THE GAME . . . ";
COLOR 10, 0: PRINT "END, EXIT, Q, QUIT"

COLOR 11, 0: LOCATE 14, 9: PRINT "GET HELP . . . . . ";
COLOR 10, 0: PRINT "H, HELP, ?"

COLOR 11, 0: LOCATE 16, 9: PRINT "DIRECTIONS . . . . ";
COLOR 10, 0: PRINT "N, NORTH, E, EAST, W, WEST, S, SOUTH"

COLOR 11, 0: LOCATE 18, 9: PRINT "ACTIONS. . . . . . ";
COLOR 10, 0: PRINT "EXAMINE <item>, GO <direction>,"
LOCATE 19, 28: PRINT "TALK TO <thing>, OPEN <item>"

COLOR 11, 0: LOCATE 21, 9: PRINT "CHECK INVENTORY. . ";
COLOR 10, 0: PRINT "I, INV, INVENTORY, ITEMS"

_DISPLAY
SLEEP

END SUB



' **************************************************************************************
' SHOW INVENTORY
' **************************************************************************************
SUB ShowInventory ()

CLS

DrawBox 3, 2, 78, 29, 3, 1, 176
DrawBox 5, 3, 76, 8, 11, 3, 178 '10, 9, 178

_PRINTMODE _KEEPBACKGROUND

COLOR 14, 0
LOCATE 5, 19: PRINT "INVENTORY: SEE WHAT ITEMS YOU ARE CARRYING"
LOCATE 6, 14: PRINT "---=== IF YOU DON'T SEE IT, YOU DON'T HAVE IT ==---"
LOCATE 26, 15: PRINT "THE CLOCK IS STILL TICKING AND TIME IS RUNNING OUT!"
LOCATE 27, 14: PRINT "YOU BETTER GET BACK TO THE GAME.";
COLOR 9, 0: PRINT "  HINT: PRESS ANY KEY";

COLOR 11, 0: LOCATE 10, 7: PRINT "ITEM NAME";
COLOR 10, 0: LOCATE 10, 23: PRINT "ITEM DESCRIPTION";
COLOR 11, 0: LOCATE 11, 7: PRINT STRING$(14, "-");
COLOR 10, 0: LOCATE 11, 23: PRINT STRING$(52, "-");

CurrentCursorY% = 13
NumberOfItemsInInventory% = 0

FOR i = 0 TO UBOUND(Inventory)

    IF Inventory(i).InInventory = 1 THEN

        COLOR 11, 0: LOCATE CurrentCursorY%, 7: PRINT Inventory(i).Item
        COLOR 10, 0: LOCATE CurrentCursorY%, 23: PRINT RTRIM$(LTRIM$(Inventory(i).InventoryMessage))

        CurrentCursorY% = CurrentCursorY% + 1
        NumberOfItemsInInventory% = NumberOfItemsInInventory% + 1

    END IF

NEXT

IF NumberOfItemsInInventory% = 0 THEN

    COLOR 14
    LOCATE CurrentCursorY%, 7: PRINT "YOU HAVE NOT FOUND ANYTHING AT THIS POINT, SO I SUGGEST THAT YOU"
    LOCATE CurrentCursorY% + 1, 7: PRINT "KEEP SEARCHING... IF YOU NEED HELP, TYPE 'HELP', 'H', '?'"

END IF



_DISPLAY
SLEEP

END SUB

' **************************************************************************************
'  SHOW BAD LANGUAGE POPUP
' **************************************************************************************
SUB ShowBadLanguage ()

CLS
DrawBox 3, 13, 78, 16, 14, 4, 178

_PRINTMODE _KEEPBACKGROUND

LanguageWarning = LanguageWarning + 1
LOCATE 14, 7: PRINT "PLEASE DO NOT USE VOLUGAR LANGUAGE IN THIS GAME, OR GAME WILL END";
LOCATE 15, 24: PRINT "YOU HAVE BEEN WARNED"; LanguageWarning; "TIMES...";

IF LanguageWarning = 3 THEN
    LOCATE 18, 25: PRINT "WE WARNED YOU! GAME OVER DUDE!";
    _DISPLAY
    SLEEP
    SYSTEM
END IF

_DISPLAY
SLEEP
END SUB


' **************************************************************************************
' DRAW BOX
' **************************************************************************************
SUB DrawBox (X1, Y1, X2, Y2, BorderColor1%, FillColor1%, BackgroundChar%%)


COLOR FillColor1%, 0

FOR y = Y1 TO Y2
    LOCATE y, X1
    PRINT STRING$(X2 - X1 + 1, BackgroundChar%%);
NEXT

_PRINTMODE _KEEPBACKGROUND

COLOR BorderColor1%, 0

LOCATE Y1, X1: PRINT CHR$(201);
LOCATE Y2, X1: PRINT CHR$(200);
LOCATE Y1, X2: PRINT CHR$(187);
LOCATE Y2, X2: PRINT CHR$(188);
LOCATE Y1, X1 + 1: PRINT STRING$(X2 - X1 - 1, CHR$(205));
LOCATE Y2, X1 + 1: PRINT STRING$(X2 - X1 - 1, CHR$(205));

FOR y = Y1 + 1 TO Y2 - 1
    LOCATE y, X1: PRINT CHR$(186);
    LOCATE y, X2: PRINT CHR$(186);
NEXT

_PRINTMODE _FILLBACKGROUND

END SUB



' **************************************************************************************
' GET ITEM
' **************************************************************************************
FUNCTION GetItem% (Item$)

GetItem% = -1

FOR i = 0 TO UBOUND(inventory)
    IF UCASE$(RTRIM$(Inventory(i).Item)) = UCASE$(Item$) THEN GetItem% = i: EXIT FOR
NEXT

END FUNCTION


' **************************************************************************************
' IS IN INVENTORY
' **************************************************************************************
FUNCTION IsInInventory% (Item$)

IsInInventory% = 0

' CHECK TO SEE IF WE HAVE THE ITEM IN THE LIST OF ITEMS THAT COULD BE IN THE INVENTORY
IF GetItem(Item$) = -1 THEN EXIT SUB

IF Inventory(GetItem(Item$)).InInventory = 1 THEN
    IsInInventory% = 1
ELSE
    IsInInventory% = 0
END IF

END FUNCTION


' **************************************************************************************
' DISPLAY ROOM INFORMATION
' **************************************************************************************
SUB DisplayRoomInformation (Room AS INTEGER)

SELECT CASE Room
    CASE 153
        PRINT "The scent of the fresh night air lingers around you. You have no clue"
        PRINT "how you came to be here? The last thing you remember is lying down in"
        PRINT "bed...watching TV."

    CASE 152
        PRINT "You are standing before a vast field. The grass looks as if it's being"
        PRINT "cared for."

    CASE 154
        PRINT "The sky is alive with the dancing light from the sky. Other worlds"
        PRINT "that may or may not exist anymore. Light your path and give you warmth."

    CASE 143
        PRINT "With every step you take, you feel the cold damp grass pillow the"
        PRINT "souls of your feet. You'd expect it to be freezing, being in a field"
        PRINT "in the middle of the night, and with Fall just right around the corner."
        PRINT "But...you'd be surprised."

    CASE 144
        PRINT "You look over all that stands before you. You feel as if you are finally"
        PRINT "at peace with your surroundings."

    CASE 131
        PRINT "The faint sound of children's laughter. Just where are you? And"
        PRINT "where are those who are laughing?"

    CASE 132
        PRINT "You feel a cold breeze pass by you...odd, you should have shivered"
        PRINT "but you didn't."

    CASE 133
        PRINT "In the distance, you see a swarm of firefly's dancing in the darkness."
        PRINT "The light they give off makes it look as if the faint image of children playing"
        PRINT "in the darkness before you...just where the hell are you?"

    CASE 120
        PRINT "-Hey, do you know where our parents are?- The voice of a child asks."
        PRINT "You quickly turn to find that no one is there."

    CASE 121
        PRINT "The cold breeze quickly vanishes and you feel as if you are alone."

    CASE 123
        PRINT "You want to leave this place. You feel like a stranger in a strange land."
        PRINT "Hearing the voices of those trapped within this place."

    CASE 124
        PRINT "This time you hear the laughter of adults. As if they are conversing with"
        PRINT "one another. Like a party is taking place here. But all you see is darkness."

    CASE 125
        PRINT "The laughter fades away and you are standing alone...in silence."

    CASE 112
        PRINT "The path slowly begin's to winde down with every step you take."

    CASE 113
        PRINT "You feel the eye's of hundreds of people watching you. As if they know your there."

    CASE 115
        PRINT "You feel your lungs begin to ache and the taste of blood fills your"
        PRINT "mouth."

    CASE 101
        PRINT "With every step you take, you feel your limbs ache."

    CASE 102
        PRINT "The night sky fills the field with almost an eerie glow."

    CASE 103
        PRINT "The silence finally begin's to take its toll on you. You begin to wonder"
        PRINT "just what in thw world is going on here?"

    CASE 90
        PRINT "The cold grass gently touches your leg."

    CASE 91
        PRINT "The smell of freshly cut grass fills the air. Soon the scent of rotten flesh"
        PRINT "quickly over powers you."

    CASE 92
        PRINT "The world is a dark place for those who are blind to the wonders of life."

    CASE 93
        PRINT "Madness...as you hear the voices of people begging for mercy."

    CASE 94
        PRINT "With every step you take, you can swear to hear what could only be described"
        PRINT "as a sorta hell on Earth."

    CASE 80
        PRINT "You see the ever expanding field. But the path doesn't cross into the shadows."

    CASE 81
        PRINT "A cold breeze races past you. You feel a chill."

    CASE 82
        PRINT "You feel the need to flee this place...but from what?"

    CASE 83
        PRINT "You feel your body slowly begin to go numb. Just where am I?"

    CASE 84
        PRINT "The trail begin's to narrow and shrink with every step taken."

        '      12345678901234567890123456789012345678901234567890123456789012345678901234567890

END SELECT

IF CountDoorsInRoom > 0 THEN

    '  SAVE CURENT COLOR FOR RESTORE LATER
    PreviousColor% = _DEFAULTCOLOR

    COLOR 12, 0
    PRINT "ONE OR MORE LOCKED DOORS WERE DETECTED... ";

    IF (Directions AND 1) AND (Map(CurrentRoom) AND 1) = 1 THEN PRINT "N)orth  ";
    IF (Directions AND 2) AND (Map(CurrentRoom) AND 2) = 2 THEN PRINT "E)ast  ";
    IF (Directions AND 4) AND (Map(CurrentRoom) AND 4) = 4 THEN PRINT "W)est  ";
    IF (Directions AND 8) AND (Map(CurrentRoom) AND 8) = 8 THEN PRINT "S)outh"

    _DISPLAY

    COLOR PreviousColor%

END IF

END SUB


' **************************************************************************************
' CHECK IF BAD COMMAND
' **************************************************************************************
FUNCTION CheckIfBadCommand ()

' THIS FUNCTION ASSUMES THERE ARE TOKENS IN THE TOKENS$ ARRAY

CheckIfBadCommad = 0

FOR Word = 0 TO UBOUND(wordlist$)
    FOR Token = 0 TO UBOUND(Tokens$)
        IF UCASE$(WordList$(Word)) = Tokens$(Token) THEN CheckIfBadCommand = 1
    NEXT
NEXT

END FUNCTION


' **************************************************************************************
' COUNT THE NUMBER OF DOORS AVAILABLE IN CURRENT ROOM
' **************************************************************************************
FUNCTION CountDoorsInRoom ()

CountDoorsInRoom = 0
Directions = (Map(CurrentRoom) AND &HF0) / 16

FOR i% = 0 TO 3
    IF ((Directions AND 2 ^ i%) = 2 ^ i%) AND ((Map(CurrentRoom) AND 2 ^ i%) > 0) THEN CountDoorsInRoom = CountDoorsInRoom + 1
NEXT

END FUNCTION


' **************************************************************************************
' GET WHICH DOOR IS LOCKED IF THERE IS ONLY ONE LOCKED DOOR IN THE ROOM
' **************************************************************************************
FUNCTION WhichDoorIsLocked ()

WhichDoorIsLocked = 0
DoorLockedCounter = 0

Directions = (Map(CurrentRoom) AND &HF0) / 16

FOR i% = 0 TO 3
    IF ((Directions AND 2 ^ i%) = 2 ^ i%) AND ((Map(CurrentRoom) AND 2 ^ i%) > 0) THEN
        WhichDoorIsLocked = Map(CurrentRoom) AND 2 ^ i%
        DoorLockedCounter = DoorLockedCounter + 1
    END IF
NEXT

IF DoorLockedCounter > 1 THEN WhichDoorIsLocked = 0

END FUNCTION


' **************************************************************************************
' SLICE COMMANDS
' **************************************************************************************
SUB SliceCommands (NewCommands$)

' IF THERE ARE NO COMMANDS AVAILABLE THE EXIT SUB
IF LEN(NewCommands$) = 0 THEN EXIT SUB

DIM StringPosition AS INTEGER
DIM LastStringPosition AS INTEGER
REDIM Tokens$(-1)

StringPosition = 1
LastStringPosition = 0

DO

    ' FIND THE NEXT SPACE
    StringPosition = INSTR(LastStringPosition, NewCommands$, " ")

    ' IF NO MORE SPACES ARE FOUND THEN EXIT SUB.
    IF (StringPosition = 0) AND (LastStringPosition >= LEN(NewCommands$)) THEN EXIT DO 'EXIT SUB

    ' NO MORE SPACES WHERE FOUND, BUT THERE WAS ANOTHER TOKEN
    IF StringPosition = 0 THEN StringPosition = LEN(NewCommands$) + 1

    ' SINCE A SPACE WAS FOUND, MAKE SURE THERE WAS A COMMAND BETWEEN THE PREVIOUS SPACE AND THE NEW ONE
    IF (StringPosition - LastStringPosition) > 0 THEN

        ' RESIZE THE GLOBAL TOKENS$ ARRAY TO MAKE ROOM FOR THE NEXT TOKEN
        REDIM _PRESERVE Tokens$(UBOUND(Tokens$) + 1)

        ' GET NEW TOKEN
        Tokens$(UBOUND(Tokens$)) = MID$(NewCommands$, LastStringPosition, (StringPosition - LastStringPosition))

        ' SKIP CURRENT SPACE
        LastStringPosition = StringPosition + 1

        ' SEE IF WE SPLICED THE LAST TOKEN AND IF SO EXIT THE DO...LOOP
        IF LastStringPosition > LEN(NewCommands$) THEN EXIT DO

        ' LET'S MAKE SURE THE USER DIDN'T ADD A BUNCH OF SPACES SINCE THAT WOULD BREAK THE SPLICER AND PUT IT IN AN INFINITE LOOP
        DO
            ' GET THE CURRENT CHARACTER IN THE STRING
            char$ = MID$(NewCommands$, LastStringPosition, 1)

            ' IF THE CHARACTER IS NOT A SPACE THEN EXIT THIS DO...LOOP
            IF char$ <> CHR$(32) THEN EXIT DO

            ' IT APPEARS THE CAHARACTER IS A SPACE SO INCREMENT THE POINTER BY ONE
            LastStringPosition = LastStringPosition + 1

            ' IF THE POINTER IS PAST THE LAST CHARACTER IN THE STRING, THEN BREAK OUT OF THE SUB
            IF LastStringPosition > LEN(NewCommands$) THEN EXIT SUB

        LOOP

    END IF

LOOP

END SUB


' **************************************************************************************
' GET A KEY
' **************************************************************************************
FUNCTION GetKey% ()

'  CLEAR THE KEYBOARD BUFFER
DO
    k = _KEYHIT
    i$ = INKEY$
LOOP UNTIL k = 0 AND INKEY$ = ""

DO
    _LIMIT 10
    GetKey% = _KEYHIT
    IF GetKey% > 0 THEN EXIT FUNCTION

LOOP

END FUNCTION


' **************************************************************************************
' CLEAR MESSAGE BOX
' **************************************************************************************
SUB ClearMessageBox ()

_PRINTMODE _FILLBACKGROUND

FOR y = 22 TO 27
    LOCATE y, 1: PRINT SPACE$(80);
NEXT

LOCATE 22, 1

END SUB

' **************************************************************************************
' GET INPUT AND PARSE
' **************************************************************************************
SUB GetInputAndParse ()

' ASK USER FOR INPUT
LOCATE 28, 3: COLOR 11, 0: PRINT "COMMAND:";: COLOR 14, 0: PRINT "> ";: COLOR 2, 0

' GET USER INPUT. THE GRABINPUT FUNCTION DOES NOT RETURN UNTIL USER PRESSES THE <ENTER> KEY
cmd$ = LTRIM$(RTRIM$(UCASE$(GrabInput)))
NewCmd$ = cmd$

IF LEN(NewCmd$) = 0 THEN EXIT SUB

' SLICE NEW COMMANDS INTO A GLOBAL NEWCOMMANDS ARRAY
SliceCommands (NewCmd$)

' SEE IF THE USER HAS USED IN BAD WORDS, AND IF SO WARN THEM AND/OR END THE GAME
IF CheckIfBadCommand = 1 THEN ShowBadLanguage: EXIT SUB

' CHECK TO SEE IF THE USER WANTS TO END THE GAME
IF Tokens$(0) = "END" OR Tokens$(0) = "QUIT" OR Tokens$(0) = "Q" THEN UserEndedGame

' SEE IF THE USER NEEDS HELP
IF Tokens$(0) = "HELP" OR Tokens$(0) = "H" OR Tokens$(0) = "?" THEN ShowHelp

' SEE IF THE USER WANTS TO LOOK AT THE INVENTORY
IF Tokens$(0) = "ITEMS" OR Tokens$(0) = "INVENTORY" OR Tokens$(0) = "INV" OR Tokens$(0) = "I" THEN ShowInventory


' GET AVAILABLE DIRECTIONS
Directions = (Map(CurrentRoom) AND &HF0) / 16
Doors = Map(CurrentRoom) AND &H0F

SELECT CASE Tokens$(0)

    CASE "NORTH", "N"

        IF (Directions AND 1) AND (CurrentRoom - MapWidth) > 0 AND (Doors AND 1) = 0 THEN CurrentRoom = CurrentRoom - MapWidth

    CASE "SOUTH", "S"

        IF (Directions AND 8) AND (CurrentRoom + MapWidth) > 0 AND (Doors AND 8) = 0 THEN CurrentRoom = CurrentRoom + MapWidth

    CASE "EAST", "E"

        IF (Directions AND 2) AND (CurrentRoom + 1) < (MapWidth * MapHeight) AND (Doors AND 2) = 0 THEN CurrentRoom = CurrentRoom + 1

    CASE "WEST", "W"

        IF (Directions AND 4) AND (CurrentRoom - 1) > 0 AND (Doors AND 4) = 0 THEN CurrentRoom = CurrentRoom - 1

    CASE "GO"

        ' CHECK TO SEE IF WE HAVE ENOUGH TOKENS TO CHECK, AND IF NOT EXIT THE SUB
        IF UBOUND(tokens$) < 1 THEN EXIT SUB

        SELECT CASE Tokens$(1)

            CASE "NORTH", "N"

                IF (Directions AND 1) AND (CurrentRoom - MapWidth) > 0 AND (Doors AND 1) = 0 THEN CurrentRoom = CurrentRoom - MapWidth

            CASE "SOUTH", "S"

                IF (Directions AND 8) AND (CurrentRoom + MapWidth) > 0 AND (Doors AND 8) = 0 THEN CurrentRoom = CurrentRoom + MapWidth

            CASE "EAST", "E"

                IF (Directions AND 2) AND (CurrentRoom + 1) < (MapWidth * MapHeight) AND (Doors AND 2) = 0 THEN CurrentRoom = CurrentRoom + 1

            CASE "WEST", "W"

                IF (Directions AND 4) AND (CurrentRoom - 1) > 0 AND (Doors AND 4) = 0 THEN CurrentRoom = CurrentRoom - 1

        END SELECT

    CASE "EXAMINE"

        ' CHECK TO SEE IF WE HAVE ENOUGH TOKENS TO CHECK, AND IF NOT EXIT THE SUB
        IF UBOUND(tokens$) < 1 THEN EXIT SUB

        ClearMessageBox

        SELECT CASE Tokens$(1)

            CASE "WATCH" '  COMMAND: "EXAMINE KEY"

                IF IsInInventory(Tokens$(1)) = 1 THEN
                    PRINT "An old timely peice crafted by the hands of an ancient watchmaker. A talent long"
                    PRINT "since forgotten from a forgotten time. A place to where, you wish you could"
                    PRINT "visit but neither have the money nor time."
                    '      12345678901234567890123456789012345678901234567890123456789012345678901234567890
                END IF

        END SELECT

        IF IsInInventory(Tokens$(1)) = 0 THEN

            ' SAVE THE CURRENT TEXT COLOR
            c% = _DEFAULTCOLOR

            ' CHANGE THE TEXT COLOR AND PRINT OUR MESSAGE
            COLOR 4
            PRINT "BEFORE I CAN EXAMINE '"; Tokens$(1); "' IT MUST BE IN MY INVENTORY BAG"

            ' CHANGE THE TEXT COLOR BACK TO THE PREVIOUS ONE
            COLOR c%
        END IF

        PRINT: PRINT "PRESS ANY KEY...";: _DISPLAY: SLEEP

    CASE "OPEN"

        ' CHECK TO SEE IF WE HAVE ENOUGH TOKENS TO CHECK, AND IF NOT EXIT THE SUB
        IF UBOUND(tokens$) < 1 THEN EXIT SUB

        ClearMessageBox

        SELECT CASE Tokens$(1)

            CASE "WATCH" '  COMMAND: "USE KEY"

                IF IsInInventory(Tokens$(1)) = 1 AND Doors > 0 THEN 'AND (Map(CurrentRoom) AND &H01) AND CurrentRoom = 43 THEN

                    NumOfDoors% = CountDoorsInRoom

                    IF NumOfDoors% > 1 THEN

                        PRINT ">> Which portal would you like to point the watch at?"
                        PRINT

                        IF (Map(CurrentRoom) AND 1) = 1 THEN PRINT "N) North Door   ";
                        IF (Map(CurrentRoom) AND 2) = 2 THEN PRINT "E) East Door   ";
                        IF (Map(CurrentRoom) AND 4) = 4 THEN PRINT "W) West Door   ";
                        IF (Map(CurrentRoom) AND 8) = 8 THEN PRINT "S) South Door"

                        _DISPLAY

                        DO
                            Choice$ = UCASE$(CHR$(GetKey%))

                            IF Choice$ = "N" OR Choice$ = "E" OR Choice$ = "W" OR Choice$ = "S" THEN

                                IF (Map(CurrentRoom) AND 1) = 1 AND (Choice$ = "N") THEN Map(CurrentRoom) = Map(CurrentRoom) AND &HFE
                                IF (Map(CurrentRoom) AND 2) = 2 AND (Choice$ = "E") THEN Map(CurrentRoom) = Map(CurrentRoom) AND &HFD
                                IF (Map(CurrentRoom) AND 4) = 4 AND (Choice$ = "W") THEN Map(CurrentRoom) = Map(CurrentRoom) AND &HFB
                                IF (Map(CurrentRoom) AND 8) = 8 AND (Choice$ = "S") THEN Map(CurrentRoom) = Map(CurrentRoom) AND &HF7

                                EXIT DO
                            END IF

                        LOOP

                    ELSE

                        LockedDoor = WhichDoorIsLocked

                        IF LockedDoor = 1 THEN Map(CurrentRoom) = Map(CurrentRoom) AND &HFE
                        IF LockedDoor = 2 THEN Map(CurrentRoom) = Map(CurrentRoom) AND &HFD
                        IF LockedDoor = 4 THEN Map(CurrentRoom) = Map(CurrentRoom) AND &HFB
                        IF LockedDoor = 8 THEN Map(CurrentRoom) = Map(CurrentRoom) AND &HF7

                    END IF

                    ClearMessageBox

                    PRINT "When I opened the pocket watch and pointed it towards the portal, the watch"
                    PRINT "began to hum in my hand. The portal immediately flashed a warm, peaceful, bright"
                    PRINT "light that feels very inviting. I feel as though I should go through and see"
                    PRINT "where it takes me."
                    '      12345678901234567890123456789012345678901234567890123456789012345678901234567890
                END IF

        END SELECT

        IF IsInInventory(Tokens$(1)) = 0 THEN

            ' SAVE THE CURRENT TEXT COLOR
            c% = _DEFAULTCOLOR

            ' CHANGE THE TEXT COLOR AND PRINT OUR MESSAGE
            COLOR 4
            PRINT "YOU CAN'T USE AN ITEM YOU DON'T HAVE IN YOUR INVENTORY BAG."
            PRINT "YOUR INVENTORY BAG DOES NOT CONTAIN: '"; Tokens$(1); "'"
            '      12345678901234567890123456789012345678901234567890123456789012345678901234567890

            ' CHANGE THE TEXT COLOR BACK TO THE PREVIOUS ONE
            COLOR c%
        ELSE
            EXIT SUB
        END IF

        PRINT: PRINT "PRESS ANY KEY...";: _DISPLAY: SLEEP

    CASE "TALK"

        ' CHECK TO SEE IF WE HAVE ENOUGH TOKENS TO CHECK, AND IF NOT EXIT THE SUB
        IF UBOUND(tokens$) < 1 THEN EXIT SUB

        ClearMessageBox

        c% = _DEFAULTCOLOR
        COLOR 4

        PRINT "As I struggle to let out a single word, nothing seems to come forth. It appears"
        PRINT "I am unable to talk in this strange place. Matter of fact, I can't remember the"
        PRINT "last time I took a breath."
        '      12345678901234567890123456789012345678901234567890123456789012345678901234567890

        PRINT: PRINT "PRESS ANY KEY...";: _DISPLAY: SLEEP

        COLOR c%

        EXIT SUB

    CASE "GET", "TAKE"

        IF UBOUND(tokens$) < 1 THEN EXIT SUB

        SELECT CASE Tokens$(1) '  GET, TAKE

            CASE "BREATH"

                ClearMessageBox

                '  SAVE CURENT COLOR FOR RESTORE LATER
                c% = _DEFAULTCOLOR

                COLOR 14

                PRINT "I tried to inhale as hard as I could, but it is as though my lungs didn't exist."
                PRINT "Matter of fact, I don't remember the last time I took a breath. Very strange."
                '      12345678901234567890123456789012345678901234567890123456789012345678901234567890

                _DISPLAY: SLEEP

                COLOR c%
                EXIT SUB


        END SELECT

END SELECT


END SUB



' **************************************************************************************
' GRAB INPUT
' **************************************************************************************
FUNCTION GrabInput$ ()

x = POS(0)
y = CSRLIN
maxwidth = _WIDTH - x
PCOPY 0, 1 'make a backup copy of the screen

DO
    k = _KEYHIT
    i$ = INKEY$
LOOP UNTIL k = 0 AND INKEY$ = "" 'clear the keyboard buffer


DO
    _LIMIT 30
    PCOPY 1, 0
    COLOR 10, 0
    LOCATE y, x: PRINT Userinput$

    k = _KEYHIT
    SELECT CASE k
        CASE 8
            Userinput$ = LEFT$(Userinput$, LEN(Userinput$) - 1)
        CASE 65 TO 90, 97 TO 122, 32, 63
            Userinput$ = UCASE$(Userinput$ + CHR$(k))
    END SELECT

    timerleft## = (DoomTime - TIMER(0.001))
    minutes## = timerleft## \ 60
    seconds## = timerleft## - minutes## * 60

    COLOR 10, 8
    LOCATE 2, 34: PRINT USING " ###:##.###  "; minutes##, seconds##

    IF timerleft## <= 0 THEN TimesUp

    _DISPLAY

LOOP UNTIL k = 13

GrabInput$ = Userinput$

_DISPLAY

COLOR 2, 0

END FUNCTION

' **************************************************************************************
' YOU WIN
' **************************************************************************************
SUB YouWin ()

COLOR 1, 1

CLS

DrawBox 3, 2, 78, 29, 10, 2, 176
DrawBox 5, 3, 76, 9, 10, 2, 178

_PRINTMODE _KEEPBACKGROUND


COLOR 14

LOCATE 12, 7: PRINT "You awaken in bed the next morning. You look around and as you pull"
LOCATE 13, 7: PRINT "back the covers...you notice that the sheets are stained with mud."
LOCATE 14, 7: PRINT "The world you have ventured into, was the void between the living and"
LOCATE 15, 7: PRINT "the dead, and you were lucky enough to leave with your soul."
LOCATE 17, 7: PRINT ""
LOCATE 17, 7: PRINT "Thank you for playing."

LOCATE 27, 23: PRINT "PRESS ANY KEY TO END YOUR STORY..."

_DISPLAY

SLEEP
SYSTEM

END SUB


' **************************************************************************************
' YOU LOSE
' **************************************************************************************
SUB YouLose ()

COLOR 1, 1

CLS

DrawBox 3, 2, 78, 29, 14, 4, 176
DrawBox 5, 3, 76, 9, 14, 4, 178 '10, 9, 178

_PRINTMODE _KEEPBACKGROUND

LOCATE 12, 7: PRINT "The harsh light of the morning Sun passes through the barren and"
LOCATE 13, 7: PRINT "slowly you fade out from existence. Leaving behind nothing to"
LOCATE 14, 7: PRINT "remember you by."
LOCATE 15, 7: PRINT ""
LOCATE 17, 7: PRINT "Better Luck Next Time..."

LOCATE 27, 23: PRINT "PRESS ANY KEY TO END YOUR STORY..."

_DISPLAY

SLEEP
SYSTEM

END SUB


' **************************************************************************************
' TIMES UP
' **************************************************************************************
SUB TimesUp ()

COLOR 1, 1

CLS

DrawBox 3, 2, 78, 29, 14, 4, 176
DrawBox 5, 3, 76, 9, 14, 4, 178 '10, 9, 178

_PRINTMODE _KEEPBACKGROUND

LOCATE 12, 7: PRINT "You have spent to much time within this realm that boarders the"
LOCATE 13, 7: PRINT "living and the dead. Now, you must wander this plain of existence"
LOCATE 14, 7: PRINT "for all eternity...poor soul."
LOCATE 20, 7: PRINT ""
LOCATE 27, 23: PRINT "PRESS ANY KEY TO END YOUR STORY..."

_DISPLAY

SLEEP
SYSTEM

END SUB


' **************************************************************************************
' USER ENDED GAME
' **************************************************************************************
SUB UserEndedGame ()

COLOR 14, 5

CLS

DrawBox 3, 2, 78, 29, 9, 1, 176
DrawBox 5, 3, 76, 10, 9, 1, 178 '10, 9, 178

_PRINTMODE _KEEPBACKGROUND

COLOR 14

'  S1-E8: TIME ENOUGH AT LAST
'                   1234567890123456789012345678901234567890123456789012345678901234567

LOCATE 13, 7: PRINT "Thank you for playing 'Death Cometh'."
LOCATE 14, 7: PRINT ""
LOCATE 15, 7: PRINT "WRITTEN BY: Written By: D.B. Taylor"
LOCATE 16, 7: PRINT "Copyrighted 2015, By D.B. Taylor. All Rights Reserved."
LOCATE 17, 7: PRINT ""
LOCATE 18, 7: PRINT "GAME ENGINE BY: D.B. Taylor and Walter Whitman"
LOCATE 19, 7: PRINT ""
LOCATE 20, 7: PRINT ""
LOCATE 27, 23: PRINT "PRESS ANY KEY TO END YOUR STORY..."

_DISPLAY

SLEEP


SYSTEM

END SUB

' HEX Value: (i.e.: &h12) 1 = Moveable Direction, 2 = Locked Door --> MOVE/LOCK DOOR
'
' HEX Value Definitions:
'
'    &h0 [0000] = MOVE/LOCK DOOR - No Moves
'    &h1 [0001] = MOVE/LOCK DOOR - North
'    &h2 [0010] = MOVE/LOCK DOOR - East
'    &h3 [0011] = MOVE/LOCK DOOR - East North
'    &h4 [0100] = MOVE/LOCK DOOR - West
'    &h5 [0101] = MOVE/LOCK DOOR - West North
'    &h6 [0110] = MOVE/LOCK DOOR - West East
'    &h7 [0111] = MOVE/LOCK DOOR - West East North
'    &h8 [1000] = MOVE/LOCK DOOR - South
'    &h9 [1001] = MOVE/LOCK DOOR - South North
'    &hA [1010] = MOVE/LOCK DOOR - South East
'    &hB [1011] = MOVE/LOCK DOOR - South East North
'    &hC [1100] = MOVE/LOCK DOOR - South West
'    &hD [1101] = MOVE/LOCK DOOR - South West North
'    &hE [1110] = MOVE/LOCK DOOR - South West East
'    &hF [1111] = MOVE/LOCK DOOR - South West East North

DATA &h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00
DATA &h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00
DATA &h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00
DATA &h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00
DATA &h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00
DATA &h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00
DATA &h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00
DATA &h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00,&h00
DATA &hA0,&h60,&h60,&h60,&hC0,&h00,&h00,&h00,&h00,&h00
DATA &h30,&hC0,&h80,&hA0,&h50,&h00,&h00,&h00,&h00,&h00
DATA &h00,&h30,&hF0,&h50,&h00,&h00,&h00,&h00,&h00,&h00
DATA &h00,&h00,&h30,&hC0,&h00,&h80,&h00,&h00,&h00,&h00
DATA &h20,&hC0,&h00,&hB0,&h60,&h50,&h00,&h00,&h00,&h00
DATA &h00,&h30,&h60,&hD0,&h00,&h00,&h00,&h00,&h00,&h00
DATA &h00,&h00,&h00,&h90,&h80,&h00,&h00,&h00,&h00,&h00
DATA &h00,&h00,&h20,&h70,&h50,&h00,&h00,&h00,&h00,&h00

DATA "Watch",0,1,"My grandfather's old pocket watch. Oh how I loved him."
DATA "END_OF_ITEMS",0,0,""


'  DECODE KEY
DATA "                               mcU7q}`;#db9P?,rL2\I<[YZ!k>.]l_WNKew%nMu@5C*DX-6ghT1p$zJAj+v8'OQ&Gif/FsV4{ B~x)(RH0|3Et:yS^=oa"

'  Number of phrases
DATA 9

'  ENCODED PHRASES
DATA "F3i ","F3i my)3","f&~xm4|","s)fmf&~x","s)fmf&~xm4|","s)fmf&~x4|","s)|mF3i my)3H0/BF","0V4|","/&|m0V4|"

